unit fROR_UserList;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 11 $  $Modtime: 3/07/07 3:30p $
*       Site:           Hines OIFO
*       Developers:                     @domain.ext
*
*       Description:    List of registry users
*
*       Notes:
*
================================================================================
*       $Archive: /CCR v1.5/Current/fROR_UserList.pas $
*
* $History: fROR_UserList.pas $
 * 
 * *****************  Version 11  *****************
 * User: Vhaishgavris Date: 3/08/07    Time: 1:47p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 10  *****************
 * User: Vhaishgavris Date: 3/02/05    Time: 11:54a
 * Updated in $/CCR v1.0/Current
 *
 * *****************  Version 9  *****************
 * User: Vhaishgavris Date: 3/01/05    Time: 4:54p
 * Updated in $/CCR v1.0/Current
 *
 * *****************  Version 8  *****************
 * User: Vhaishgavris Date: 1/10/05    Time: 3:48p
 * Updated in $/CCR v1.0/Current
 *
 * *****************  Version 7  *****************
 * User: Vhaishgavris Date: 11/18/04   Time: 3:57p
 * Updated in $/CCR v1.0/Current
 *
 * *****************  Version 6  *****************
 * User: Vhaishgavris Date: 10/14/04   Time: 3:50p
 * Updated in $/CCR v1.0/Current
 *
================================================================================
}

interface

uses
  Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, uROR_CustomControls, uROR_GridView, fROR_VistARegistries,
  uROR_CustomListView, StdCtrls, ComCtrls;

type
  TFormUserList = class(TForm)
    pnlMain: TPanel;
    lvUserList: TCCRGridView;
    Panel1: TPanel;
    btnOK: TBitBtn;
    procedure FormCreate(Sender: TObject);

  public
    function Load(aRegInfo: TRegistryInfo): Boolean;

  published
    procedure ApplyOptions;

  end;

procedure ShowUserList(aRegInfo: TRegistryInfo);

implementation
{$R *.DFM}

uses
  uROR_Broker, uROR_Common, uROR_Utilities, fROR_GenericRegistry, fROR_Options;

procedure ShowUserList(aRegInfo: TRegistryInfo);
begin
  with TFormUserList.Create(Application) do
    try
      if Load(aRegInfo) then
        ShowModal;
    finally
      Free;
    end;
end;

procedure TFormUserList.ApplyOptions;
var
  ie: TCCRInterfaceElement;
begin
  inherited;
  ie := CCROptions.IE[ieReadOnly];
  lvUserList.Color := ie.Color;
  lvUserList.Font.Color := ie.FontColor;
end;

procedure TFormUserList.FormCreate(Sender: TObject);
begin
  ApplyOptions;
end;

function TFormUserList.Load(aRegInfo: TRegistryInfo): Boolean;
var
  li: TCCRGridItem;
  i: Integer;
  rawData: TStringList;
begin
  rawData := TStringList.Create;
  try
    Result := Broker.CallProc(rpcGetRegistryUsers, [aRegInfo.IEN], nil, rawData);
    if Result then
      begin
        Caption := 'Users of the ' + aRegInfo.Description;
        lvUserList.Items.BeginUpdate;
        try
          lvUserList.Clear;
          for i := 1 to rawData.Count - 1 do
            begin
              li := lvUserList.Items.Add;
              //-- Section 508: Moved the Dummy Caption field to the end so JAWS
              //   will read the row correctly.
              li.AssignRawData(rawData[i], [-1,-1,2,1,3,4,5]);
              li.AsString[0] := ' ';
              li.AsInteger[1] := i;
            end;
          lvUserList.SortField := 2;
        finally
          lvUserList.Items.EndUpdate;
        end;
      end;
  finally
    rawData.Free;
  end;
end;

end.

